<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Index;

use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourPassengerIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourPassengerIndexer $inserter)
    {
    }

    public function __invoke(LeadBookingTourPassengerIndexerQuery $query): LeadBookingTourPassengerIndexerResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingTourPassenger($query->getId()));
    }
}
