<?php

namespace App\Modules\ModuleNotification\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Modules\Domain\Structure\ModuleGroup;

class BookingConfirmationNotification
{

    /** constructor */
    public function __construct(
        private string $bookingTourDateStart,
        private string $bookingTourTourName
    ) {
    }

    public function __invoke(IdAdmin $idAdmin) {
        $description = 'Tour <b>' . $this->bookingTourTourName . '<b>Confirmado al ' . $this->bookingTourDateStart;
        $module = new ModuleGroup();
        $moduleNotification = new InsertModuleNotification(
            new ModuleNotificationDescription($description),
            new ModuleNotificationType(ModuleNotificationType::BOOKING_CONFIRMATION),
            new ModuleNotificationModule($module->name()),
            $idAdmin
        );
        return $moduleNotification;
    }
}
