<?php

namespace App\Modules\PackageTour\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\PackageTour\Domain\PackageTour;
use App\Modules\PackageTour\Domain\PackageTourRepository;
use App\Modules\PackageTour\Domain\IdPackageTour;
use App\Modules\PackageTour\Domain\UpdatePackageTour;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPackageTourRepository implements PackageTourRepository
{

    public function find(IdLeadBooking $idLeadBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_package_tour_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function index(IdPackageTour $id)
    {
        return Requester::requestSelect(
            'CALL sp_package_tour_index_alter(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
