<?php

namespace App\Modules\Passenger\Infraestructure;

class PassengerValidators
{

    public const UPDATE = [
        'Id_Passenger'          => 'required|int',
        'Passenger_Name'        => 'string|max:250',
        'Passenger_LastName'    => 'string|max:250',
        'Passenger_Email'       => 'string|max:250',
        'Passenger_Phone'       => 'string|max:100',
        'Passenger_Gender'      => 'string|max:250',
        'Passenger_DOB'         => 'string|max:250',
        'Passenger_NoDocument'  => 'string|max:250',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Passenger_Status'      => 'required|int',
        'Id_TypeDocument'       => 'required|int',
        'Id_UserCountry'        => 'required|int'
    ];

    public static function getUpdateDocuments($imageMimeType)
    {
        return [
            'Id_Passenger'              => 'required|int',
            'Passenger_ImgDocument1'    => 'image|mimes:' . $imageMimeType,
            'Passenger_ImgDocument2'    => 'image|mimes:' . $imageMimeType
        ];
    }
}
