<?php

namespace App\Modules\PassengerReview\Application;

use App\Modules\PassengerReview\Domain\IdPassengerReview;
use App\Modules\PassengerReview\Domain\PassengerReviewRestoreRepository;

class PassengerReviewRestore
{
    private PassengerReviewRestoreRepository $repository;

    public function __construct(PassengerReviewRestoreRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(int $idReview)
    {
        return $this->repository->restore(new IdPassengerReview($idReview));
    }
}
