<?php

namespace App\Modules\PassengerReview\Infraestructure;

use App\Modules\PassengerReview\Domain\IdPassengerReview;
use App\Modules\PassengerReview\Domain\PassengerReviewRestoreRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPassengerReviewRestoreRepository implements PassengerReviewRestoreRepository
{
    public function restore(IdPassengerReview $idReview)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_restore(?,@sts,@cod,@msg)',
            [
                $idReview->value()
            ]
        );
    }
}
