<?php

namespace App\Modules\PaxInformation\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Shared\Domain\QueryList\ListInput;

final class PaxInformationInsert
{

    private PaxInformationRepository $repository;

    public function __construct(
        PaxInformationRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(
        PaxInformationDescription $description,
        PaxInformationRemaining $remaining,
        PaxInformationDateExpire $expire,
        PaxInformationStatus $status,
        IdBooking $idBooking,
        IdAdmin $idAdmin
    ):array {
        $model = $this->repository->insert($description, $remaining, $expire, $status, $idBooking, $idAdmin);
        return $model;
    }
}
