<?php

namespace App\Modules\PaxInformationPassenger\Domain;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;

final class PaxInformationPassengerInsert
{

    private PaxInformationPassengerRepository $repository;

    public function __construct(
        PaxInformationPassengerRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(
        PaxInformationPassengerRemaining $remaining,
        PaxInformationPassengerStatus $status,
        IdPaxInformation $idPaxInformation,
        IdPassenger $idPassenger
    ):array {
        $model = $this->repository->insert($remaining, $status, $idPaxInformation, $idPassenger);
        return $model;
    }
}
