<?php

namespace App\Modules\ReviewNotification\Application\Accept;

use App\Modules\ReviewNotification\Application\Accept\ReviewNotificationAccepterResponse;
use App\Modules\ReviewNotification\Domain\AcceptReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationAccepter
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(AcceptReviewNotification $reviewNotification): ReviewNotificationAccepterResponse
    {
        return new ReviewNotificationAccepterResponse($this->repository->accept($reviewNotification));
    }
}
