<?php

namespace App\Modules\ReviewNotification\Infraestructure;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewNotification\Domain\AcceptReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\InsertReviewNotification;
use App\Modules\ReviewNotification\Domain\UpdateReviewNotification;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlReviewNotificationRepository implements ReviewNotificationRepository
{

    public function find(IdGroupPassenger $idGroupPassenger, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_review_notification_list(?,?,@sts,@cod,@msg)',
            [
                $idGroupPassenger->value(),
                $action
            ]
        );
    }

    public function index(IdReviewNotification $id)
    {
        return Requester::requestSelect(
            'CALL sp_review_notification_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertReviewNotification $value)
    {
        $element = Requester::requestInsert(
            'CALL sp_review_notification_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getDescription()->value(),
                $value->getStatus()->value(),
                $value->getIdGroupPassenger()->value(),
                $value->getIdAdmin()->value(),
                $value->getIdReviewNotificationParent()->value()
            ]
        );
        return $element;
    }

    public function update(UpdateReviewNotification $value)
    {
        return Requester::requestUpdate(
            'CALL sp_review_notification_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getDescription()->value(),
                $value->getStatus()->value(),
            ]
        );
    }

    public function accept(AcceptReviewNotification $value)
    {
        return Requester::requestUpdate(
            'CALL sp_review_notification_accept(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getResponse()->value(),
                $value->getIdAdmin()->value()
            ]
        );
    }

    public function delete(IdReviewNotification $id)
    {
        return Requester::requestUpdate(
            'CALL sp_review_notification_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
