<?php

namespace App\Modules\Shared\Domain;

use App\Modules\Shared\Exceptions\InvalidRequestException;

class GenerateActionException {
    
    public function __invoke (string $message, int $code = 406, int $status = 406) {
        throw new InvalidRequestException([
            "Response_Status"			=> $code,
            "Response_Code"				=> $status,
            "Response_Domain"			=> 'global',
            "Response_Message"			=> $message,
            "Response_Data"				=> NULL,
            "Response_Error_Message"	=> $message,
            "Response_Error_Reason"		=> $message,
        ]);
    }
}