<?php

namespace App\Modules\TourHtlCamp\Domain;

class TourHtlCamp {

    private TourHtlCampDay $day;
    private TourHtlCampStatus $status;
    private THCIdTour $idTour;
    private THCIdHtlCamp $idHtlCamp;
    private ?IdTourHtlCamp $id;


    /** constructor */
    public function __construct (
        TourHtlCampDay $day,
        TourHtlCampStatus $status,
        THCIdTour $idTour,
        THCIdHtlCamp $idHtlCamp,
        ?IdTourHtlCamp $id = NULL
    ) {
        $this->day = $day;
        $this->status = $status;
        $this->idTour = $idTour;
        $this->idHtlCamp = $idHtlCamp;
        $this->id = $id;
    }

    public function getDay():TourHtlCampDay { return $this->day; }
    public function getIdTour():THCIdTour { return $this->idTour; }
    public function getIdHtlCamp():THCIdHtlCamp { return $this->idHtlCamp; }
    public function getStatus():TourHtlCampStatus { return $this->status; }
    public function getId():IdTourHtlCamp { return $this->id; }

}