<?php

namespace App\Providers\ExcelInvoiceListReport;

use App\Http\Helpers\CashMovementHelper;

class InvoiceListCells {

    private function titleMerge ($text) { return [
        [ 'action' => 'wrap' ],
        [ 'action' => 'border' ],
        [ 'action' => 'print', 'text' => $text ],
        [ 'action' => 'bold'],
        [ 'action' => 'merge', 'lines' => 1 ],
        [ 'action' => 'border' ],
    ]; }
    private function title ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }
    private function titleNoBorders ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold'], [ 'action' => 'merge', 'lines' => 1 ],]; }
    private function titlePrinc ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold'],['action' => 'center'], [ 'action' => 'merge', 'lines' => 4 ], ['action' => 'size','lines'=>14]]; }
    private function footerMerge ($text) { return [[ 'action' => 'wrap' ],[ 'action' => 'border' ],  [ 'action' => 'print', 'text' => $text ], ['action' => 'center'],[ 'action' => 'bold'], [ 'action' => 'merge', 'lines' => 1 ],[ 'action' => 'border' ],]; }
    private function column ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ]]; }
    
    private function columnNoBorders ($text) { return [[ 'action' => 'wrap' ],  [ 'action' => 'print', 'text' => $text ]]; }
    private function columnNoBordersBold ($text) { return [[ 'action' => 'wrap' ],  [ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }
    private function columnMerge ($text) { return [
        [ 'action' => 'wrap' ],
        [ 'action' => 'border' ],
        [ 'action' => 'print', 'text' => $text ],
        [ 'action' => 'merge', 'lines' => 1 ],
        [ 'action' => 'border' ],
    ]; }

    

    private function createInvoices (array $invoices) {
        return array_map (
            function ($curr) {
                return [
                        $this->columnMerge ("invoices"),
                        $this->column (date('Y-m-d', strtotime($curr->Invoice_Date))),
                        $this->column ($curr->Passenger_Name . ' ' . $curr->Passenger_LastName),
                        $this->column ($curr->Invoice_TotalPay),
                        $this->column ($curr->Invoice_TotalPending),
                        $this->column ($curr->Invoice_Total),
                    ];
            },
            $invoices,
            
        );
    }

    private function createInvoiceDetails (array $invoices) {
        $v = $this;
        return array_merge ( 
            $v->createInvoiceDetail($invoices[0]->Invoice_Detail,$invoices[0]->InvoiceRes),
            $v->createInvoiceFees($invoices[0]->Invoice_Fee),
            $v->createPayments($invoices[0]->Pays)
        );
        // return array_reduce (
        //     $invoices,
        //     function ($carry, $invoice) use ($v) {
        //         $carry = array_merge (
        //             $carry,
        //             [
        //                 [],
        //                 [
        //                    // $this->titleNoBorders ($invoice->Invoice_Code)
        //                 ]
        //             ],
        //             $v->createInvoiceDetail($invoice->Invoice_Detail),
        //             $v->createInvoiceFees($invoice->Invoice_Fee),
        //         );
        //         return $carry;
        //     },
        //     []
        // );
    }

    private function createInvoiceDetail ($invoiceDetail,$ResumeINvoice) {
        return array_merge (
            [
                [],
                [
                    $this->titleNoBorders ('DETALLE')
                ],
                [],
                [
                    $this->title ('ITEM'),
                    $this->title ('CANTIDAD'),
                    $this->title ('P/U'),
                    $this->title ('TOTAL'),
                ]
            ],
            array_map (
                function ($detail, $key) {
                    return [
                        $this->column ($detail->InvoiceDetail_Description),
                        $this->column ($detail->InvoiceDetail_Quantity),
                        $this->column ($detail->InvoiceDetail_Price),
                        $this->column ($detail->InvoiceDetail_Total),
                    ];
                },
                $invoiceDetail,
                array_keys ($invoiceDetail)
            ),
            [
                [
                    $this->footerMerge('TOTAL'),
                    $this->titleMerge ($ResumeINvoice["Total"]),
                ]
                ],
            [
                [
                    $this->footerMerge('DEPOSIT'),
                    $this->titleMerge ($ResumeINvoice["TotalPay"]),
                ]
                ],
                
            [
                [
                    $this->footerMerge('BALANCE'),
                    $this->titleMerge ($ResumeINvoice["TotalPending"]),
                ]
            ]

        );
    }

    

    private function createInvoiceFees ($invoiceFees) {
        return array_merge (
            [
                [],
                [
                    $this->titleNoBorders ('CUOTAS')
                ],
                [],
                [
                    $this->title ('PASAJERO'),
                    $this->title ('PAGADO'),
                    $this->title ('PENDIENTE'),
                    $this->title ('TOTAL'),
                ]
            ],
            array_map (
                function ($fee, $key) {
                    return [
                        $this->column ($fee->Passenger_Name.''.$fee->Passenger_LastName),
                        $this->column ($fee->InvoiceFee_AmountPay),
                        $this->column ($fee->InvoiceFee_Amount - $fee->InvoiceFee_AmountPay),
                        $this->column ($fee->InvoiceFee_Amount),
                    ];
                },
                $invoiceFees,
                array_keys ($invoiceFees)
            ),

        );
    }
    private function createPayments($cashmov) {
         return array_merge (
             [
                 [],
                 [
                     $this->titleNoBorders ('PAGOS')
                 ],
                 [],
                 [
                     $this->title ('TIPO DE PAGO'),
                     $this->title ('FECHA'),
                     $this->title ('NUMERO DE RECIBO'),
                     $this->title ('PAGADOR'),
                     $this->title ('CANTIDAD'),
                 ]
             ],
             array_map (
                 function ($cash, $key) {
                     return [
                         $this->column ($cash->TypePayment_Name),
                         $this->column (date('Y-m-d', strtotime($cash->CashMovement_DatePayment))),
                         $this->column (CashMovementHelper::changeReceiptNumber($cash)),
                         $this->column ($cash->CashMovement_Name.' '.$cash->CashMovement_LastName),
                         $this->column ($cash->CashMovement_Type==1?$cash->CashMovementDetail_Amount*-1:$cash->CashMovementDetail_Amount),
                     ];
                 },
                 $cashmov,
                 array_keys ($cashmov)
             )
         );
     }
    
    public function run ($invoices, $oMetadata) {
        return array_merge (
            [
                [],
                [
                    $this->titlePrinc('INVOICE - '.str_pad($invoices[0]->Booking[0]->Id_Booking, 7, "0", STR_PAD_LEFT)),
                ],
                [
                    $this->columnNoBorders('NOMBRE DEL CONTACTO'),
                    $this->columnNoBordersBold($invoices[0]->Booking[0]->User_Name." ".$invoices[0]->Booking[0]->User_Name),
                    $this->columnNoBorders('PAIS DEL CONTACTO'),
                    $this->columnNoBordersBold($invoices[0]->Booking[0]->UserCountry_Name),
                ],
                [
                    $this->columnNoBorders('TELÉFONO DEL CONTACTO'),
                    $this->columnNoBordersBold('('.$invoices[0]->Booking[0]->User_PhoneCode.')'. $invoices[0]->Booking[0]->User_Phone),
                    $this->columnNoBorders('EMAIL DEL CONTACTO'),
                    $this->titleNoBorders($invoices[0]->Booking[0]->User_Email),
                ],
                [
                    $this->columnNoBorders('FECHA DE RESERVA'),
                    $this->columnNoBordersBold($invoices[0]->Booking[0]->Booking_Date),
                    $this->columnNoBorders('CODIGO RESERVA'),
                    $this->columnNoBordersBold($invoices[0]->Booking[0]->Booking_Code),
                ]
            ],
          //  $this->createInvoices($invoices),
            $this->createInvoiceDetails ($invoices)
        );
    }
}