<?php

function main($directory, $name, $newName)
{
    try {
        run($directory, $name, $newName);
    } catch (\Throwable $ex) {
        echo $ex->getMessage();
    }
}

function run($directory, $name, $newName)
{
    tap('checkDir')($directory);
    $info = getInfo($directory);
    $newDir = $info->getDirname() . DIRECTORY_SEPARATOR . transform($info->getBasename(), $name, $newName);
    if (!mkdir($newDir, 0777, true)) {
        throw new Exception('It can\'t be created: ' . $newDir);
    }
    goThrough($directory . DIRECTORY_SEPARATOR, '', mirrorCreate($newDir, $directory, $name, $newName));
}

function transform($filename, $name, $newName)
{
    $text = str_replace($name, $newName, $filename);
    return str_replace(lcfirst($name), lcfirst($newName), $text);
}


function mirrorCreate(string $newDir, string $dir, $name, $newName)
{
    return function (bool $isDir, string $lastDir, string $item) use ($newDir, $dir, $name, $newName) {
        if ($isDir) {
            $dirname = $newDir . DIRECTORY_SEPARATOR . transform($item, $name, $newName);
            mkdir($dirname);
            echo 'Directory Created: ' . $dirname . "\n";
        } else {
            $filename = $newDir . DIRECTORY_SEPARATOR . transform($item, $name, $newName);
            copyFrom(
                $dir . DIRECTORY_SEPARATOR . $item,
                $filename,
                $name,
                $newName
            );
            echo 'File Created: ' . $filename . "\n";
        }
    };
}

function copyFrom($from, $to, $name, $newName)
{
    $lastFile = fopen($from, "r");
    if (!$lastFile) {
        throw new Exception('Unable to open file ' . $from);
    }
    $text = transform(fread($lastFile, filesize($from)), $name, $newName);
    fclose($lastFile);
    $newFile = fopen($to, "w");
    if (!$newFile) {
        throw new Exception('Unable to open file ' . $to);
    }
    fwrite($newFile, $text);
    fclose($newFile);
}

function checkDir($pathDir)
{
    if (!is_dir($pathDir)) {
        throw new Exception('Is not a directory: ' . $pathDir);
    }
}

function goThrough($dir, $lastDir, callable $callback)
{
    $array = array_diff(scandir($dir . $lastDir), array('.', '..'));
   
    foreach ($array as &$item) {
        $item = $lastDir . $item;
    }
    unset($item);
    foreach ($array as $item) {
        $isDir = is_dir($dir . $item);
        $callback($isDir, $lastDir, $item);
        if ($isDir) {
            $array = array_merge($array, goThrough($dir, $item . DIRECTORY_SEPARATOR, $callback));
        }
    }
    return $array;
}

class PathInfo
{
    public function __construct(
        private string $dirname,
        private string $basename,
        private string $filename
    ) {
    }
    public function getDirname(): string
    {
        return $this->dirname;
    }
    public function getBasename(): string
    {
        return $this->basename;
    }
    public function getExtension(): string
    {
        return $this->extension;
    }
    public function getFilename(): string
    {
        return $this->filename;
    }
}

function getInfo($path)
{
    $data = pathinfo($path, PATHINFO_ALL);
    return new PathInfo(
        $data['dirname'],
        $data['basename'],
        $data['filename']
    );
}

function tap(callable $tapFn)
{
    return function (...$arguments) use ($tapFn) {
        $tapFn(...$arguments);
        return count($arguments) === 1 ? array_shift($arguments) : [ ...$arguments ];
    };
}

main($argv[1], $argv[2], $argv[3]);
