<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->put(
    '/bookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@update'
    ]
);

$router->get(
    '/bookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@index'
    ]
);

$router->post(
    '/bookingTour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@addPackage'
    ]
);

$router->put(
    '/bookingTour/change',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@Change'
    ]
);

$router->get(
    '/bookingTour/{Id}/report',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@Report'
    ]
);

$router->delete(
    '/bookingTour/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour@Delete'
    ]
);
