<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalReviewProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderInsertController@__invoke'
    ]
);

$router->put(
    '/externalReviewProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalReviewProvider/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderDeleteController@__invoke'
    ]
);

$router->get(
    '/externalReviewProvider/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderIndexController@__invoke'
    ]
);

$router->get(
    'externalReview/{IdExternalReview:[0-9]*}/externalReviewProvider/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReviewProvider\\ExternalReviewProviderListController@__invoke'
    ]
);
