<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/htlUsage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Insert'
    ]
);

$router->put(
    '/htlUsage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Update'
    ]
);

$router->delete(
    '/htlUsage/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Delete'
    ]
);

$router->get(
    '/htlUsage/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@Index'
    ]
);

$router->get(
    '/htlRoom/{Id_HtlRoom:[0-9]*}/htlUsage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@List'
    ]
);

$router->get(
    '/htlCamp/{Id_HtlCamp:[0-9]*}/htlUsage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlUsage@CampList'
    ]
);