<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Lead\Domain\LeadRepository;
use App\Modules\Lead\Infraestructure\MysqlLeadRepository;

$app->bind(LeadRepository::class, fn($app) => $app->make(MysqlLeadRepository::class));

$router->post(
    '/lead',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadInsertController@__invoke'
    ]
);

$router->put(
    '/lead',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadUpdateController@__invoke'
    ]
);

$router->delete(
    '/lead/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadDeleteController@__invoke'
    ]
);

$router->get(
    '/lead/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadIndexController@__invoke'
    ]
);

$router->get(
    '/lead/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadListController@__invoke'
    ]
);
