<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/paxInformation',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@insert'
    ]
);

$router->put(
    '/paxInformation',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@update'
    ]
);

$router->put(
    '/paxInformation/utilize',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@update'
    ]
);

$router->delete(
    '/paxInformation/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@delete'
    ]
);

$router->get(
    '/paxInformation/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@index'
    ]
);

$router->get(
    '/booking/{Id_Booking:[0-9]*}/paxInformation/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@list'
    ]
);
