<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/provider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@Insert'
    ]
);
$router->put(
    '/provider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@Update'
    ]
);
$router->delete(
    '/provider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@Delete'
    ]
);

$router->get(
    '/provider/score/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@listScore'
    ]
);
$router->get(
    '/provider/review',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@ListReview'
    ]
);
$router->get(
    '/provider/service',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@ListServices'
    ]
);
$router->get(
    '/provider/service/excel',
    [
        'uses' => 'c_Provider@ListServicesExcel'
    ]
);

$router->get(
    '/provider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Provider@Selector'
    ]
);
