<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\ReviewSession\Domain\ReviewSessionRepository;
use App\Modules\ReviewSession\Infraestructure\MysqlReviewSessionRepository;

$router->post(
    '/reviewSession',
    [
        'uses' => 'ReviewSession\\ReviewSessionCreateController@__invoke'
    ]
);

$router->get(
    '/reviewSession',
    [
        'uses' => 'ReviewSession\\ReviewSessionIndexController@__invoke'
    ]
);

$router->get(
    '/reviewSession/detail/{idGroupProvider:[0-9]*}',
    [
        'uses' => 'ReviewSession\\ReviewSessionDetailController@__invoke'
    ]
);

$app->bind(ReviewSessionRepository::class, fn($app) => $app->make(MysqlReviewSessionRepository::class));
